/* ============ */
/* pmtchisq.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <miscdefs.h>
#include <pmtndefs.h>
#include <assert.h>

#define	FULL_SIZE  ((unsigned)RAND_MAX + 1U)
int ScoreCard[FULL_SIZE];
/* ======================================================================= */
/* CalcPermuteChiSq - Calculates Chi-Square Statistic for Permutation Test */
/* ======================================================================= */
void
CalcPermuteChiSq(PRMUT_DATA_STRU  *PermuteData)
{
    long    k;
    double  Coef, SumSq = 0;

    memset(ScoreCard, 0, sizeof(int) * PermuteData->NumCategories);

    /* ----------------------------------------------------------- */
    /* Generate NumObs (= NumCategories * CellExpect) Permutations */
    /* ----------------------------------------------------------- */
    for (k = 0; k < (long)PermuteData->NumObs; ++k)
    {
	int	NextValue;

	NextValue = AnalyzeNextPermutation(PermuteData);
	++ScoreCard[NextValue];
    }

    /* ------------------------------ */
    /* Calculate Chi-Square Statistic */
    /* ------------------------------ */
    for (k = 0; k < PermuteData->NumCategories; ++k)
    {
	SumSq += SQR((double)ScoreCard[k]);
    }

    Coef = (double)PermuteData->NumCategories /
		(double)PermuteData->NumObs;

    PermuteData->PrmutChiSq =
	Coef * SumSq - (double)PermuteData->NumObs;
}
